<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>寻宠寻主管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
            //$("#name").focus();
            $("#inputForm").validate({
                submitHandler: function (form) {
                    loading('正在提交，请稍等...');
                    form.submit();
                },
                errorContainer: "#messageBox",
                errorPlacement: function (error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
        });
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctx}/petLostAndFound/">寻宠寻主列表</a></li>
    <li class="active"><a
            href="${ctx}/petlostandfound/petLostAndFound/form?id=${petLostAndFound.id}">寻宠寻主<shiro:hasPermission
            name="petlostandfound:petLostAndFound:edit">${not empty petLostAndFound.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission
            name="petlostandfound:petLostAndFound:edit">查看</shiro:lacksPermission></a></li>
</ul>
<br/>
<form:form id="inputForm" modelAttribute="petLostAndFound" action="${ctx}/petLostAndFound/save"
           method="post" class="form-horizontal">
    <form:hidden path="id"/>
    <sys:message content="${message}"/>
    <div class="control-group">
        <label class="control-label">编号：</label>
        <div class="controls">
                ${petLostAndFound.lostAndFoundCode}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">寻宠/寻主：</label>
        <div class="controls">
                ${fns:getDictLabel(petLostAndFound.lostAndFoundType, 'lost_and_found_type', '')}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">宠物名：</label>
        <div class="controls">
                ${petLostAndFound.petName}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">性别：</label>
        <div class="controls">
                ${fns:getDictLabel(petLostAndFound.petGender, 'pet_gender', '')}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">宠物种类：</label>
        <div class="controls">
                ${fns:getDictLabel(petLostAndFound.petType, 'pet_type', '')}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">颜色：</label>
        <div class="controls">
                ${petLostAndFound.petCoatColor}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">城市：</label>
        <div class="controls">
                ${petLostAndFound.city}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">地点：</label>
        <div class="controls">
                ${petLostAndFound.location}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">日期：</label>
        <div class="controls">
            <fmt:formatDate value="${petLostAndFound.time}" pattern="yyyy-MM-dd HH:mm"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">联系人：</label>
        <div class="controls">
                ${petLostAndFound.linkman}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">联系电话：</label>
        <div class="controls">
                ${petLostAndFound.phone}
        </div>
    </div>
    <div class="control-group">
        <div style="width: 100%;float: left;height: 25px">
            <div style="width: 720px;float: left">
                <label class="control-label">详细信息：</label><div class="controls">${petLostAndFound.remarks} </div>
            </div>
            <div style="width: 30%;float: left">
                <label class="control-label">审核状态：</label><label>${fns:getDictLabel(petLostAndFound.reviewState, 'lost_and_found_review_state', '')}</label>
            </div>
        </div>
    </div>
    <div class="control-group" style="width: 100%;">
        <div style="width: 100%;float: left;height: 190px">
            <label class="control-label">照片：</label>
            <div id="${picture}" style="float: left;width:620px">
                <c:forEach items="${pictures}" var="picture">
                    <img id="test4" style="margin-left: 20px;height: 180px;width: 180px" class="imgs" src="${pageContext.request.contextPath}/pub/file/image/${picture}">
                </c:forEach>
            </div>

            <c:if test="${petLostAndFound.reviewState==2}">
                <div style="margin-left:32px;width: 40%;float: left;">
                  未通过原因： ${petLostAndFound.reviewRemarks}
                </div>
            </c:if>
        </div>
    </div>
    <div class="form-actions">
        <shiro:hasPermission name="petlostandfound:petLostAndFound:edit"><input id="btnSubmit" class="btn btn-primary"
                                                                                type="submit"
                                                                                value="保 存"/>&nbsp;</shiro:hasPermission>
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
</body>
</html>