/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.votes.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cab.passport.votes.entity.VoteUser;
import com.cab.passport.votes.service.VoteUserService;

/**
 * votesController
 * @author wj
 * @version 2020-05-12
 */
@Controller
@RequestMapping(value = "${adminPath}/votes/voteUser")
public class VoteUserController extends BaseController {

	@Autowired
	private VoteUserService voteUserService;
	
	@ModelAttribute
	public VoteUser get(@RequestParam(required=false) String id) {
		VoteUser entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = voteUserService.get(id);
		}
		if (entity == null){
			entity = new VoteUser();
		}
		return entity;
	}
	
	@RequiresPermissions("votes:voteUser:view")
	@RequestMapping(value = {"list", ""})
	public String list(VoteUser voteUser, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<VoteUser> page = voteUserService.findPage(new Page<VoteUser>(request, response), voteUser); 
		model.addAttribute("page", page);
		return "passport/votes/voteUserList";
	}

	@RequiresPermissions("votes:voteUser:view")
	@RequestMapping(value = "form")
	public String form(VoteUser voteUser, Model model) {
		model.addAttribute("voteUser", voteUser);
		return "passport/votes/voteUserForm";
	}

	@RequiresPermissions("votes:voteUser:edit")
	@RequestMapping(value = "save")
	public String save(VoteUser voteUser, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, voteUser)){
			return form(voteUser, model);
		}
		voteUserService.save(voteUser);
		addMessage(redirectAttributes, "保存votes成功");
		return "redirect:"+Global.getAdminPath()+"/votes/voteUser/?repage";
	}
	
	@RequiresPermissions("votes:voteUser:edit")
	@RequestMapping(value = "delete")
	public String delete(VoteUser voteUser, RedirectAttributes redirectAttributes) {
		voteUserService.delete(voteUser);
		addMessage(redirectAttributes, "删除votes成功");
		return "redirect:"+Global.getAdminPath()+"/votes/voteUser/?repage";
	}

}