/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.votes.entity;

import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

/**
 * votesEntity
 * @author wj
 * @version 2020-05-12
 */
public class Votes extends DataEntity<Votes> {

	private static final long serialVersionUID = 1L;
	private String schoolCode;		// 学校编号
	private VoteUser voteUser;		// 投票用户id
	private String votes;		// 票数

	public Votes() {
		super();
	}

	public Votes(String id){
		super(id);
	}

	@Length(min=1, max=64, message="学校编号长度必须介于 1 和 64 之间")
	public String getSchoolCode() {
		return schoolCode;
	}

	public void setSchoolCode(String schoolCode) {
		this.schoolCode = schoolCode;
	}

	public VoteUser getVoteUser() {
		return voteUser;
	}

	public void setVoteUser(VoteUser voteUser) {
		this.voteUser = voteUser;
	}

	@Length(min=1, max=16, message="票数长度必须介于 1 和 16 之间")
	public String getVotes() {
		return votes;
	}

	public void setVotes(String votes) {
		this.votes = votes;
	}

}