<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>天猫护照订单管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {

        });
        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/passportOrder/tmall/">天猫护照订单列表</a></li>
    <shiro:hasPermission name="passportOrder:tmall:edit">
        <li><a href="${ctx}/passportOrder/tmall/form">天猫护照订单添加</a></li>
    </shiro:hasPermission>
</ul>
<form:form id="searchForm" modelAttribute="passportOrder" action="${ctx}/passportOrder/tmall/" method="post"
           class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>天猫订单号：</label>
            <form:input path="tmallOrderCodeLike" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>手机号：</label>
            <form:input path="consigneePhoneLike" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>旺旺ID：</label>
            <form:input path="wangwangIdLike" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>购买套餐：</label>
            <form:select path="packageType" class="input-medium">
                <form:option value="" label="全部"/>
                <form:options items="${fns:getDictList('passport_order_package_type')}" itemLabel="label"
                              itemValue="value" htmlEscape="false"/>
            </form:select>
        </li>
        <%--<li><label>下单时间：</label>--%>
            <%--<input name="orderTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"--%>
                   <%--value="<fmt:formatDate value="${passportOrder.orderTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"--%>
                   <%--onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/>--%>
        <%--</li>--%>
        <li><label>业务状态：</label>
            <form:select path="tmallBusinessState" class="input-medium">
                <form:option value="" label="全部"/>
                <form:option value="1" label="待处理"/>
                <form:option value="2" label="待发货"/>
                <form:option value="3" label="已发货"/>
            </form:select>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>天猫订单号</th>
        <th>姓名</th>
        <th>电话</th>
        <th>购买套餐</th>
        <th>下单时间</th>
        <th>更新时间</th>
        <th>订单状态</th>
        <th>快递号</th>
        <shiro:hasPermission name="passportOrder:tmall:view">
            <th>操作</th>
        </shiro:hasPermission>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="passportOrder">
        <tr>
            <td>
                    ${passportOrder.tmallOrderCode}
            </td>
            <td>
                    ${passportOrder.consigneeName}
            </td>
            <td>
                    ${passportOrder.consigneePhone}
            </td>
            <td>
                    ${fns:getDictLabel(passportOrder.packageType, 'passport_order_package_type', '')}
            </td>
            <td>
                <fmt:formatDate value="${passportOrder.orderTime}" pattern="yyyy-MM-dd HH:mm"/>
            </td>
            <td>
                <fmt:formatDate value="${passportOrder.updateDate}" pattern="yyyy-MM-dd HH:mm"/>
            </td>
            <td>
                <c:if test="${passportOrder.businessState=='1'}">待处理</c:if>
                <c:if test="${passportOrder.businessState=='2'||passportOrder.businessState=='3'}">待发货</c:if>
                <c:if test="${passportOrder.businessState=='4'||passportOrder.businessState=='5'||passportOrder.businessState=='6'}">已发货</c:if>
            </td>
            <td>
                    ${passportOrder.expressNumber}
            </td>
            <td>
                <shiro:hasPermission name="passportOrder:tmall:view">
                    <a href="${ctx}/passportOrder/tmall/view?id=${passportOrder.id}">查看</a>
                </shiro:hasPermission>
                <shiro:hasPermission name="passportOrder:tmall:edit">
                    <c:if test="${passportOrder.businessState=='1'}"><a
                            href="${ctx}/passportOrder/tmall/edit?id=${passportOrder.id}">修改</a></c:if>
                </shiro:hasPermission>
            </td>

        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>