/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.petlostandfound.web;

import com.cab.passport.petlostandfound.entity.PetLostAndFound;
import com.cab.passport.petlostandfound.service.PetLostAndFoundService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 寻宠寻主Controller
 *
 * @author lgl
 * @version 2018-10-24
 */
@Controller
@RequestMapping(value = "${adminPath}/petLostAndFound/")
public class PetLostAndFoundController extends BaseController {

    @Autowired
    private PetLostAndFoundService petLostAndFoundService;

    private static final String REPAGE = "redirect:" + Global.getAdminPath() + "/petLostAndFound/?repage";

    private static final String AUTHORITY_PRDFIX = "petLostAndFound:";

    @ModelAttribute
    public PetLostAndFound get(@RequestParam(required = false) String id) {
        PetLostAndFound entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = petLostAndFoundService.get(id);
        }
        if (entity == null) {
            entity = new PetLostAndFound();
        }
        return entity;
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "view")
    @RequestMapping(value = {"list", ""})
    public String list(PetLostAndFound petLostAndFound, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<PetLostAndFound> page = petLostAndFoundService.findPage(new Page<PetLostAndFound>(request, response), petLostAndFound);
        model.addAttribute("page", page);
        return "petLostAndFound/petLostAndFoundList";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "view")
    @RequestMapping(value = "form")
    public String form(PetLostAndFound petLostAndFound, Model model) {
        model.addAttribute("petLostAndFound", petLostAndFound);
        if (StringUtils.isNotBlank(petLostAndFound.getPicture())) {
            String[] pictures = petLostAndFound.getPicture().split(",");
            model.addAttribute("pictures", pictures);
        }
        return "petLostAndFound/petLostAndFoundForm";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "edit")
    @RequestMapping(value = "save")
    public String save(PetLostAndFound petLostAndFound, Model model, RedirectAttributes redirectAttributes) {
        if (!beanValidator(model, petLostAndFound)) {
            return form(petLostAndFound, model);
        }
        petLostAndFoundService.save(petLostAndFound);
        addMessage(redirectAttributes, "保存寻宠寻主成功");
        return REPAGE;
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "edit")
    @RequestMapping(value = "delete")
    public String delete(PetLostAndFound petLostAndFound, RedirectAttributes redirectAttributes) {
        petLostAndFoundService.delete(petLostAndFound);
        addMessage(redirectAttributes, "删除寻宠寻主成功");
        return REPAGE;
    }

    @RequestMapping(value = "review")
    public String review(PetLostAndFound petLostAndFound, Model model) {
        model.addAttribute("petLostAndFound", petLostAndFound);
        if (StringUtils.isNotBlank(petLostAndFound.getPicture())) {
            String[] pictures = petLostAndFound.getPicture().split(",");
            model.addAttribute("pictures", pictures);
        }
        return "petLostAndFound/petLostAndFoundReview";
    }

    @RequestMapping(value = "savaReview")
    public String savaReview(PetLostAndFound petLostAndFound, Model model) {
        petLostAndFoundService.savaReview(petLostAndFound);
        return "redirect:" + Global.getAdminPath() + "/petLostAndFound/?repage";
    }

}