/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.passportorder.pub.web;

import com.cab.passport.passportorder.dao.PassportOrderDao;
import com.cab.passport.passportorder.entity.PassportOrder;
import com.cab.passport.passportorder.entity.PassportOrderBusinessStateEnum;
import com.cab.passport.passportorder.pub.entity.PetClass;
import com.cab.passport.passportorder.service.PassportOrderClubService;
import com.thinkgem.jeesite.common.utils.RESTResponse;
import com.thinkgem.jeesite.common.utils.ZAException;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import net.sf.json.JSONObject;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

/**
 * 护照订单Controller
 *
 * @author lgl
 * @version 2018-10-09
 */
@Controller
@RequestMapping(value = "pub/passportOrder")
public class PubPassportOrderController extends BaseController {

    @Autowired
    private PassportOrderClubService passportOrderClubService;
    @Autowired
    private PassportOrderDao passportOrderDao;

    @RequestMapping(value = "search")
    @ResponseBody
    public Object search(HttpServletRequest request) {
        PassportOrder po = passportOrderDao.getByIdentificationFlag(request.getParameter("identificationFlag"));
        if (po == null) {
            throw new ZAException("未查询到该芯片号码");
        }
        if (!po.getConsigneePhone().equals(request.getParameter("consigneePhone"))) {
            throw new ZAException("手机号错误");
        }
        if (PassportOrderBusinessStateEnum.IMPLANTED.getValue().equals(po.getBusinessState())) {
            throw new ZAException("该芯片已被激活");
        }
        passportOrderClubService.activeValidate(po);
        JSONObject data = new JSONObject();
        data.put("petName", po.getPetName());
        data.put("petType", DictUtils.getDictLabel(po.getPetType(), "pet_type", ""));
        data.put("identificationFlag", po.getIdentificationFlag());
        data.put("cabPassport", po.getCabPassport());
        return new RESTResponse("data", data);
    }

    @RequestMapping(value = "active")
    @ResponseBody
    public Object active(HttpServletRequest request) {
        passportOrderClubService.active(request.getParameter("identificationFlag"), request.getParameter("consigneePhone"));
        return new RESTResponse();
    }


}