/*
 * Decompiled with CFR 0.152.
 */
package com.cku.upyun;

import com.cku.upyun.VideoInfo;
import com.cku.util.DateUtils;
import com.cku.util.Debugger;
import com.cku.util.SysConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VideoInfoService {
    private static String s_ffmpegPath = null;

    public static VideoInfo getVideoRes(String fPath) throws Exception {
        String s;
        ProcessBuilder pb = new ProcessBuilder(s_ffmpegPath, "-analyzeduration", "50M", "-i", fPath);
        Process p = pb.start();
        int resultCode = p.waitFor();
        Debugger.doAssert(resultCode == 1, -7, "ffmpeg execution '%s' returns value %d", fPath, resultCode);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        VideoInfo vi = new VideoInfo();
        while ((s = bufferedReader.readLine()) != null) {
            String[] splits = s.trim().split(" ");
            boolean streamFound = false;
            boolean videoFound = false;
            boolean durationFound = false;
            for (int i = 0; i < splits.length; ++i) {
                String[] x;
                String partition = splits[i].replace(',', ' ');
                if ((partition = partition.trim()).equals("Stream")) {
                    streamFound = true;
                }
                if (partition.equals("Video:")) {
                    videoFound = true;
                }
                if (partition.equals("Duration:")) {
                    durationFound = true;
                }
                if ((x = partition.split("x")).length != 2 || !streamFound || !videoFound) continue;
                try {
                    int x1 = Integer.parseInt(x[0]);
                    int x2 = Integer.parseInt(x[1]);
                    if (x1 <= 0 || x1 > 16384 || x2 <= 0 || x2 > 9216) continue;
                    vi.vRes = x1 + "x" + x2;
                    continue;
                }
                catch (Exception x1) {
                    // empty catch block
                }
            }
            if (!durationFound) continue;
            String duration = splits[1];
            System.out.println(duration);
            Date dx = DateUtils.strToDate(duration, "HH:mm:ss.SS");
            Calendar c = Calendar.getInstance();
            c.setTime(dx);
            long time = 0L;
            time = c.get(10);
            time = time * 60L + (long)c.get(12);
            time = time * 60L + (long)c.get(13);
            time = time * 1000L + (long)c.get(14);
            vi.durationMS = time;
        }
        Debugger.doAssert(vi.vRes != null && vi.durationMS != null, -45, "Can't find resolution or duration of file %s", fPath);
        return vi;
    }

    public static String getVideoTime(String video_path) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(s_ffmpegPath);
        commands.add("-i");
        commands.add(video_path);
        try {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command(commands);
            Process p = builder.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            StringBuffer sb = new StringBuffer();
            String line = "";
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            br.close();
            String regexDuration = "Duration: (.*?), start: (.*?), bitrate: (\\d*) kb\\/s";
            Pattern pattern = Pattern.compile(regexDuration);
            Matcher m = pattern.matcher(sb.toString());
            if (m.find()) {
                String time = m.group(1);
                System.out.println(video_path + "====" + time + ",\u89c6\u9891\u65f6\u957f\uff1a" + time.substring(3, time.length() - 3) + ", \u5f00\u59cb\u65f6\u95f4\uff1a" + m.group(2) + ",\u6bd4\u7279\u7387\uff1a" + m.group(3) + "kb/s");
                return time.substring(3, time.length() - 3);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    static {
        String toolDir = SysConfig.getInstance().getProperty("tool_dir");
        String os = System.getProperty("os.name");
        s_ffmpegPath = os.toLowerCase().startsWith("win") ? toolDir + File.separator + "ffmpeg.exe" : toolDir + File.separator + "ffmpeg";
    }
}

