/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor.upload;

import com.baidu.ueditor.PathFormat;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.FileType;
import com.baidu.ueditor.define.State;
import com.cku.upyun.ImageFtp;
import com.cku.util.PathUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryUploader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final State save(HttpServletRequest request, Map<String, Object> conf) {
        boolean isAjaxUpload;
        FileItemStream fileStream = null;
        boolean bl = isAjaxUpload = request.getHeader("X_Requested_With") != null;
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            return new BaseState(false, 5);
        }
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        if (isAjaxUpload) {
            upload.setHeaderEncoding("UTF-8");
        }
        try {
            FileItemIterator iterator = upload.getItemIterator(request);
            while (iterator.hasNext() && (fileStream = iterator.next()).isFormField()) {
                fileStream = null;
            }
            if (fileStream == null) {
                return new BaseState(false, 7);
            }
            String savePath = (String)conf.get("savePath");
            String originFileName = fileStream.getName();
            String suffix = FileType.getSuffixByFilename(originFileName);
            originFileName = originFileName.substring(0, originFileName.length() - suffix.length());
            savePath = savePath + suffix;
            if (!BinaryUploader.validType(suffix, (String[])conf.get("allowFiles"))) {
                return new BaseState(false, 8);
            }
            savePath = PathFormat.parse(savePath, originFileName);
            int actionCode = (Integer)conf.get("actionCode");
            String filename = "";
            filename = 3 == actionCode ? PathUtils.specFilename() + ".mp4" : PathUtils.specFilename() + ".jpg";
            InputStream is = fileStream.openStream();
            String url = null;
            try {
                url = 3 == actionCode ? ImageFtp.uploadStream((String)ImageFtp.VIDEO_PATH_TEST, (String)filename, (InputStream)is) : ImageFtp.uploadStream((String)ImageFtp.IMAGE_PATH_TEST, (String)filename, (InputStream)is);
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            BaseState state = new BaseState(true);
            state.putInfo("title", filename);
            state.putInfo("url", url);
            state.putInfo("type", suffix);
            state.putInfo("original", originFileName + suffix);
            return state;
        }
        catch (FileUploadException e) {
            return new BaseState(false, 6);
        }
        catch (IOException e) {
            return new BaseState(false, 4);
        }
    }

    private static boolean validType(String type, String[] allowTypes) {
        List<String> list = Arrays.asList(allowTypes);
        return list.contains(type);
    }
}

